/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.helper;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import pro.gravit.launcher.base.Launcher;
import pro.gravit.launcher.base.LauncherConfig;
import pro.gravit.launcher.gui.JavaFXApplication;
import pro.gravit.launcher.gui.utils.RuntimeCryptedFile;
import pro.gravit.utils.enfs.EnFS;
import pro.gravit.utils.enfs.dir.CachedFile;
import pro.gravit.utils.enfs.dir.FileEntry;
import pro.gravit.utils.enfs.dir.RealFile;
import pro.gravit.utils.enfs.dir.URLFile;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;

public class EnFSHelper {
    private static final Set<String> themesCached = new HashSet<String>(1);
    private static final String BASE_DIRECTORY = "tgui";

    public static void initEnFS() throws IOException {
        EnFS.main.newDirectory(Paths.get(BASE_DIRECTORY, new String[0]));
        if (LogHelper.isDevEnabled() || JavaFXApplication.getInstance().isDebugMode()) {
            EnFS.DEBUG_OUTPUT = new LauncherEnFsDebugOutput();
        }
    }

    public static Path initEnFSDirectory(LauncherConfig config, String theme, Path realDirectory) throws IOException {
        String themeName = theme != null ? theme : "common";
        Path enfsDirectory = Paths.get(BASE_DIRECTORY, themeName);
        if (themesCached.contains(themeName)) {
            return enfsDirectory;
        }
        Path basePath = realDirectory == null ? Path.of("", new String[0]) : realDirectory;
        Path themePath = basePath.resolve("themes").resolve(themeName);
        if (realDirectory != null) {
            HashSet themePaths = new HashSet();
            Path relThemePath = realDirectory.relativize(themePath);
            try (Stream<Path> stream = Files.walk(realDirectory, new FileVisitOption[0]);){
                stream.forEach(f -> {
                    if (Files.isDirectory(f, new LinkOption[0])) {
                        return;
                    }
                    Path real = realDirectory.relativize((Path)f);
                    if (f.startsWith(themePath)) {
                        themePaths.add(relThemePath.relativize(real));
                    }
                });
            }
            stream = Files.walk(realDirectory, new FileVisitOption[0]);
            try {
                stream.forEach(f -> {
                    if (Files.isDirectory(f, new LinkOption[0])) {
                        return;
                    }
                    Path real = realDirectory.relativize((Path)f);
                    if (themePaths.contains(real)) {
                        f = themePath.resolve(real);
                        themePaths.remove(real);
                    }
                    try {
                        Path path = enfsDirectory.resolve(real);
                        EnFS.main.newDirectories(path.getParent());
                        RealFile entry = new RealFile(f);
                        EnFS.main.addFile(path, (FileEntry)entry);
                    }
                    catch (IOException e) {
                        LogHelper.error((Throwable)e);
                    }
                });
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        HashSet themePaths = new HashSet();
        String themePathString = String.format("themes/%s/", themeName);
        config.runtime.forEach((f, digest) -> {
            if (f.startsWith(themePathString)) {
                themePaths.add(f.substring(themePathString.length()));
            }
        });
        config.runtime.forEach((f, digest) -> {
            String real = f;
            if (themePaths.contains(real)) {
                f = themePathString.concat(real);
                digest = (byte[])config.runtime.get(f);
                themePaths.remove(real);
                LogHelper.dev((String)"Replace %s to %s", (Object[])new Object[]{real, f});
            }
            try {
                Path path = enfsDirectory.resolve(real);
                EnFS.main.newDirectories(path.getParent());
                FileEntry entry = EnFSHelper.makeFile(config, f, digest);
                LogHelper.dev((String)"makeFile %s (%s) to %s", (Object[])new Object[]{f, SecurityHelper.toHex((byte[])digest), path.toString()});
                EnFS.main.addFile(path, entry);
            }
            catch (IOException e) {
                LogHelper.error((Throwable)e);
            }
        });
        return enfsDirectory;
    }

    private static FileEntry makeFile(LauncherConfig config, String name, byte[] digest) throws IOException {
        URLFile entry;
        if (config.runtimeEncryptKey == null) {
            entry = new URLFile(Launcher.getResourceURL((String)name));
        } else {
            String encodedName = "runtime/" + SecurityHelper.toHex((byte[])digest);
            entry = new CachedFile((FileEntry)new RuntimeCryptedFile(() -> {
                try {
                    return IOHelper.newInput((URL)IOHelper.getResourceURL((String)encodedName));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }, SecurityHelper.fromHex((String)config.runtimeEncryptKey)));
        }
        return entry;
    }

    public static URL getURL(String name) throws IOException {
        URL uRL;
        block9: {
            InputStream stream = EnFS.main.getInputStream(Paths.get(name, new String[0]));
            try {
                uRL = new URI("enfs", null, "/" + name, null).toURL();
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (UnsupportedOperationException ex) {
                    throw new FileNotFoundException(name);
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
            stream.close();
        }
        return uRL;
    }

    private static class LauncherEnFsDebugOutput
    implements EnFS.DebugOutput {
        private LauncherEnFsDebugOutput() {
        }

        public void debug(String str) {
            LogHelper.debug((String)str);
        }

        public void debug(String format, Object ... args) {
            LogHelper.debug((String)format, (Object[])args);
        }
    }
}

